document.addEventListener("DOMContentLoaded", () => {

  const hamburger = document.querySelector(".hamburger");
  const navLinks = document.querySelector(".nav-links");

  if (hamburger && navLinks) {
    hamburger.addEventListener("click", () => {
      navLinks.classList.toggle("open");
    });

    navLinks.querySelectorAll("a").forEach(link => {
      link.addEventListener("click", () => navLinks.classList.remove("open"));
    });
  }

  const copyBtn = document.getElementById("copyAccountBtn");
  if (copyBtn) {
    copyBtn.addEventListener("click", async () => {
      const acc = copyBtn.dataset.account;
      await navigator.clipboard.writeText(acc);
      copyBtn.textContent = "Copied ✓";
      setTimeout(() => copyBtn.textContent = "Copy account number", 2000);
    });
  }

});
